package DTCDemo;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import net.miginfocom.swing.MigLayout;
import SDK.SDKlib;
import SDK.SDKlib.Action;
import SDK.SDKlib.ConnectionType;
import SDK.SDKlib.InfoMask;
import SDK.SDKlib.Model;
import SDK.SDKlib.PrinterInfo;
import SDK.SDKlib.PrinterType;
import SDK.SDKlib.Pro360Param;
import SDK.SDKlib.Password;
import SDK.SDKlib.Return;
import SDK.SDKlib.SDKVersion;
import SDK.SDKlib.Sensors;
import SDK.SDKlib.SmartMode;
import SDK.SDKlib.Status;

import com.sun.jna.platform.win32.WinNT.HANDLE;
import com.sun.jna.platform.win32.WinDef.BOOLByReference;
import com.sun.jna.ptr.IntByReference;

import javax.swing.border.TitledBorder;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingConstants;

import static DTCDemo.Utils.*;
import static DTCDemo.Main.tabbedPane;

//====================================================================================

class Utility {

	private final ActionHandler ah = new ActionHandler();
	
	public static final JPanel panelUtility = new JPanel();

    private final JButton btnClear = new JButton("Clear");

	private final JPanel panelSLE = new JPanel();
	private final JButton btnSendAPDU = new JButton("Send APDU");
	private final JTextArea editAPDU = new JTextArea();
    
    private final JTextArea textUtilityMsg = new JTextArea();
    private final JScrollPane scrollPane = new JScrollPane();

    private HANDLE hSession;
    private SDKlib SDK;

	private final String CLEAR      = "CLEAR";
	private final String APDU       = "APDU";
    
    //====================================================================================

	public Utility() {
		panelUtility.setLayout(new MigLayout("", "[129.00][grow]", "[][][][][][][][][][][][397.00][397.00,grow][]"));

		panelUtility.add(panelSLE, "cell 0 0 2 1,grow");
		panelSLE.setLayout(new MigLayout("", "[grow]", "[]"));
		panelSLE.setBorder(new TitledBorder(null, 
        		                                 "Single Line Encoding", 
        		                                 TitledBorder.LEADING, 
        		                                 TitledBorder.TOP, 
        		                                 null, 
        		                                 null));
        
        panelSLE.add(editAPDU, "cell 0 0,growx");
		
        panelUtility.add(scrollPane, "cell 1 1 1 12,grow");
        textUtilityMsg.setEditable(false);
        scrollPane.setViewportView(textUtilityMsg);
        
        btnSendAPDU.setActionCommand(APDU);
        btnSendAPDU.addActionListener(ah);
        panelSLE.add(btnSendAPDU, "cell 0 0");

        
        panelUtility.add(btnClear, "cell 1 13,alignx center");
		btnClear.setActionCommand(CLEAR);
		btnClear.addActionListener(ah);
    }
	
	//====================================================================================

	void Init(HANDLE handle, SDKlib sdk) {
		tabbedPane.addTab("Utility", null, panelUtility, null);

		this.hSession = handle;
    	this.SDK = sdk;

		boolean bControl = (connectedPrinter == PrinterType.GENERATION2);
		btnSendAPDU.setEnabled(bControl);
		editAPDU.setEnabled(bControl);
	}
	
	//====================================================================================

	void ClearMsg() {
		textUtilityMsg.setText(null);
	}
	
	//====================================================================================
	
	private void SendAPDU() {
		if (editAPDU.getText().length() > 1) {
			String[] apduList = editAPDU.getText().split("\n");
			for (String apdu : apduList) {
				textUtilityMsg.append("APDU Sent -> " + apdu + "\n");
				StringBuilder inputAPDU = new StringBuilder(apdu);
				StringBuilder outputAPDU = new StringBuilder();
				byte sdkReturn = SDK.ID_SendAPDU(hSession, 
						inputAPDU,
		                outputAPDU);	
				if (sdkReturn != Return.SUCCESS) {
					DisplayError("APDU", sdkReturn);
				} else {
					textUtilityMsg.append("APDU Reply: " + outputAPDU + "\n");
				}
			}
		} else {
			JOptionPane.showMessageDialog(null, 
					  "APDU Box is empty", 
					  "SDK Error", 
					  JOptionPane.INFORMATION_MESSAGE);
		}
	}

	//====================================================================================

	class ActionHandler implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			switch (e.getActionCommand()) {
			case CLEAR:      ClearMsg();      break;
			case APDU:    	 SendAPDU();      break;
			}
		}
	}
}
